/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.dicomtools;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.intelerad.lib.dicomtools.DicomDir;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DicomDirReader {
    private File mFilename;
    private DicomObject mDicomObject;
    private boolean mReadDone = false;
    private DicomDir mDicomDir;
    private DicomDir.PatientRecord mCurrentPatient = null;
    private DicomDir.StudyRecord mCurrentStudy = null;
    private DicomDir.SeriesRecord mCurrentSeries = null;

    DicomDirReader(File file) {
        this.mFilename = file;
        this.mDicomDir = new DicomDir(this.mFilename, this.mDicomObject);
    }

    DicomDir read() throws DicomException, IOException {
        if (!this.mReadDone) {
            this.readIndexFile();
            Long l2 = (Long)this.mDicomObject.get(41);
            this.mDicomDir = new DicomDir(this.mFilename, this.mDicomObject);
            this.readNodes(l2, this.buildOffsetMap());
            this.mReadDone = true;
        }
        return this.mDicomDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIndexFile() throws IOException, DicomException {
        if (this.mDicomObject != null) {
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(this.mFilename);
        try {
            this.mDicomObject = new DicomObject();
            this.mDicomObject.read((InputStream)fileInputStream);
        }
        finally {
            fileInputStream.close();
        }
    }

    private Map buildOffsetMap() {
        HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
        int n2 = this.mDicomObject.getSize(44);
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = this.mDicomObject.getOffset(44, i2);
            hashMap.put(new Long(l2), new Integer(i2));
        }
        return hashMap;
    }

    public List getPatientRecords() {
        throw new UnsupportedOperationException("not implemented!");
    }

    private void readNodes(Long l2, Map map) throws DicomException, IOException {
        Long l3;
        int n2 = (Integer)map.get(l2);
        DicomObject dicomObject = (DicomObject)this.mDicomObject.get(44, n2);
        String string = dicomObject.getS(48);
        if (string.equals("PATIENT")) {
            this.mCurrentPatient = this.mDicomDir.addPatientRecord(dicomObject);
        } else if (string.equals("STUDY")) {
            this.mCurrentStudy = this.mDicomDir.addStudyRecord(this.mCurrentPatient, dicomObject);
        } else if (string.equals("SERIES")) {
            this.mCurrentSeries = this.mDicomDir.addSeriesRecord(this.mCurrentStudy, dicomObject);
        } else if (string.equals("IMAGE")) {
            this.mDicomDir.addImageRecord(this.mCurrentSeries, dicomObject);
        } else if (string.equals("PRESENTATION")) {
            this.mDicomDir.addPresentationRecord(this.mCurrentSeries, dicomObject);
        }
        Long l4 = (Long)dicomObject.get(47);
        if (l4 != 0L) {
            this.readNodes(l4, map);
        }
        if ((l3 = (Long)dicomObject.get(45)) != 0L) {
            this.readNodes(l3, map);
        }
    }
}

