/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.dicomtools;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;

public class FileMetaInformation {
    public static final byte[] FILE_META_INFORMATION_VERSION_1 = new byte[]{0, 1};

    public static void setFileMetaInformation(DicomObject dicomObject, String string, String string2) throws DicomException {
        FileMetaInformation.setFileMetaInformation(dicomObject, null, null, string, string2);
    }

    public static void setFileMetaInformation(DicomObject dicomObject, String string, String string2, String string3, String string4) throws DicomException {
        if (string == null) {
            string = dicomObject.getS(62);
        }
        if (string2 == null) {
            string2 = dicomObject.getS(63);
        }
        if (string == null || string2 == null || string3 == null || string4 == null) {
            throw new DicomException("Invalid meta information: SOP class UID = [" + string + "], SOP instance UID = [" + string2 + "], transfer syntax UID = [" + string3 + "], implementation class UID = [" + string4 + "]");
        }
        DicomObject dicomObject2 = new DicomObject();
        dicomObject2.set(28, (Object)FILE_META_INFORMATION_VERSION_1);
        dicomObject2.set(29, (Object)string);
        dicomObject2.set(30, (Object)string2);
        dicomObject2.set(31, (Object)string3);
        dicomObject2.set(32, (Object)string4);
        dicomObject2.set(33, (Object)FileMetaInformation.getImplementationVersionName());
        dicomObject.setFileMetaInformation(dicomObject2);
    }

    static String getImplementationVersionName() {
        if ("IMS3-4-1-P107".length() > 16) {
            throw new IllegalStateException("Implementation version name longer than 16 characters [IMS3-4-1-P107]");
        }
        return "IMS3-4-1-P107";
    }

    public static int getTransferSyntax(DicomObject dicomObject) throws DicomException {
        DicomObject dicomObject2 = dicomObject.getFileMetaInformation();
        if (dicomObject2 == null) {
            return 8193;
        }
        String string = dicomObject2.getS(31);
        if (string == null) {
            return 8193;
        }
        try {
            return UID.getUIDEntry((String)string).getConstant();
        }
        catch (UnknownUIDException unknownUIDException) {
            throw new DicomException("Unknown transfer syntax uid " + string);
        }
    }
}

