/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.dicomtools;

import StringUtilities.StringStrip;
import com.archimed.dicom.DDict;
import com.archimed.dicom.DDictEntry;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import java.util.Map;
import java.util.TreeMap;

public class PrivateElement {
    public static final int MULTI_INST_GROUP = 16129;
    public static final int ATTRIBUTE_HISTORY_GROUP = 16131;
    public static final int INTELEVIEWER_GROUP = 16133;
    public static final int IMAGE_PRESENTATION_SHADOW_GROUP = 41;
    public static final int INTELEVIEWER_MARKUP_GROUP = 113;
    public static final int OVERLAY_SHADOW_GROUP = 24577;
    public static final String IMS_BLOCK_NAME = "INTELERAD MEDICAL SYSTEMS";
    public static final DDictEntry IMS_ATTRIBUTE_HISTORY = new DDictEntry(16131, 1, 10, "Attribute History", null);
    public static final DDictEntry IMS_ATTRIBUTE_HISTORY_TIMESTAMP = new DDictEntry(16131, 2, 28, "Change Timestamp", null);
    public static final DDictEntry IMS_ATTRIBUTE_HISTORY_CHANGE_INITIATOR = new DDictEntry(16131, 3, 6, "Change initiator", null);
    public static final DDictEntry IMS_ATTRIBUTE_HISTORY_CHANGE_EXPLANATION = new DDictEntry(16131, 4, 13, "Change explanation", null);
    public static final DDictEntry IMS_INSTITUTION = new DDictEntry(16129, 1, 6, "Institution", null);
    public static final DDictEntry IMS_AE_TITLE_DESTINATION = new DDictEntry(16129, 2, 7, "AE Title Destination", null);
    public static final DDictEntry IMS_SOURCE_AE_TITLE = new DDictEntry(16129, 3, 6, "Source AE Title", null);
    public static final DDictEntry IMS_DEFERRED_VALIDATION = new DDictEntry(16129, 4, 7, "Deferred Validation", null);
    public static final DDictEntry IMS_SERIES_OWNER = new DDictEntry(16129, 5, 6, "Series Owner", null);
    public static final DDictEntry IMS_GROUP_NUMBER = new DDictEntry(16129, 6, 6, "Group Number", null);
    public static final DDictEntry IMS_STRIPPED_PIXEL_DATA = new DDictEntry(16129, 7, 7, "Stripped Pixel Data", null);
    public static final DDictEntry IMS_DELAYED_MOVE_REQUEST = new DDictEntry(16129, 8, 7, "Delayed Move Request", null);
    public static final DDictEntry IMS_ASSOCIATION_DATE = new DDictEntry(16129, 10, 11, "Association Date", null);
    public static final DDictEntry IMS_ASSOCIATION_TIME = new DDictEntry(16129, 11, 12, "Association Time", null);
    public static final DDictEntry IMS_IMAGE_COMPRESSION_FRACTION = new DDictEntry(41, 1, 20, "Image Compression Fraction", null);
    public static final DDictEntry IMS_IMAGE_QUALITY = new DDictEntry(41, 2, 20, "Image Quality", null);
    public static final DDictEntry IMS_IMAGE_BYTES_TRANSFERRED = new DDictEntry(41, 3, 20, "Image Bytes Transferred", null);
    public static final DDictEntry IMS_J2C_PARAMETER_TYPE = new DDictEntry(41, 16, 7, "J2C Parameter Type", null);
    public static final DDictEntry IMS_J2C_PIXEL_REPRESENTATION = new DDictEntry(41, 17, 9, "J2C Pixel Representation", null);
    public static final DDictEntry IMS_J2C_BITS_ALLOCATED = new DDictEntry(41, 18, 3, "J2C Bits Allocated", null);
    public static final DDictEntry IMS_J2C_PIXEL_SHIFT_VALUE = new DDictEntry(41, 19, 3, "J2C Pixel Shift Value", null);
    public static final DDictEntry IMS_J2C_PLANAR_CONFIGURATION = new DDictEntry(41, 20, 3, "J2C Planar Configuration", null);
    public static final DDictEntry IMS_J2C_RESCALE_INTERCEPT = new DDictEntry(41, 21, 16, "J2C Rescale Intercept", null);
    public static final DDictEntry IMS_PIXEL_DATA_MD5SUM = new DDictEntry(41, 32, 6, "Pixel Data MD5 Sum Values", null);
    public static final DDictEntry IMS_HISTOGRAM_PERCENTILES = new DDictEntry(41, 33, 3, "Pixel Data Histogram Percentiles", null);
    public static final DDictEntry IMS_HISTOGRAM_PERCENTILE_VALUES = new DDictEntry(41, 34, 20, "Pixel Data Histogram Percentile Values", null);
    public static final DDictEntry IMS_OVERLAY_BITPOSITION = new DDictEntry(24577, 1, 3, "Overlay bit position", null);
    public static final DDictEntry IMS_IV_SOURCE_NAME = new DDictEntry(16133, 1, 6, "InteleViewer Source Name", null);
    public static final DDictEntry IMS_IV_MARKUP_TYPE = new DDictEntry(113, 1, 6, "InteleViewer Markup Type", null);
    public static final DDictEntry IMS_IV_MARKUP_TEXT = new DDictEntry(113, 2, 13, "InteleViewer Markup Text", null);
    public static final DDictEntry IMS_IV_MARKUP_TEXT_OFFSET = new DDictEntry(113, 3, 20, "InteleViewer Markup Text Offset", null);
    public static final DDictEntry IMS_IV_MARKUP_POSITION = new DDictEntry(113, 4, 20, "InteleViewer Markup Position", null);
    public static final DDictEntry IMS_IV_MARKUP_HALF_VECTOR = new DDictEntry(113, 5, 20, "InteleViewer Markup Half-Vector", null);
    public static final DDictEntry IMS_IV_MARKUP_VECTOR1 = new DDictEntry(113, 6, 20, "InteleViewer Markup Vector 1", null);
    public static final DDictEntry IMS_IV_MARKUP_VECTOR2 = new DDictEntry(113, 7, 20, "InteleViewer Markup Vector 2", null);
    public static final DDictEntry IMS_IV_MARKUP_ORTHOGONAL_POSITION = new DDictEntry(113, 8, 20, "InteleViewer Markup Orthogonal Position", null);
    public static final DDictEntry IMS_IV_MARKUP_ORTHOGONAL_HALF_VECTOR = new DDictEntry(113, 9, 20, "InteleViewer Markup Orthogonal Half-Vector", null);
    public static final DDictEntry IMS_IV_MARKUP_MINIMUM_LENGTH = new DDictEntry(113, 10, 20, "InteleViewer Markup Minimum Length", null);
    public static final DDictEntry IMS_IV_MARKUP_NUMBER_OF_POLYGONS = new DDictEntry(113, 11, 19, "InteleViewer Markup Number of Polygons", null);
    public static final DDictEntry IMS_IV_MARKUP_POLYGON_LENGTH = new DDictEntry(113, 12, 19, "InteleViewer Markup Length of Polygons", null);
    public static final DDictEntry IMS_IV_MARKUP_POINTS = new DDictEntry(113, 13, 20, "InteleViewer Markup Points", null);
    public static final DDictEntry IMS_IV_MARKUP_SLICE_SEPARATION = new DDictEntry(113, 14, 20, "InteleViewer Markup Slice Separation", null);
    public static final DDictEntry IMS_IV_MARKUP_VOLUME_OF_INTEREST = new DDictEntry(113, 15, 3, "InteleViewer Markup VOI Index", null);
    public static final DDictEntry IMS_IV_MARKUP_DATASET_TOOL_ID = new DDictEntry(113, 32, 6, "InteleViewer Markup Dataset Tool ID", null);
    public static final DDictEntry IMS_IV_MARKUP_DISTANCE_CALIBRATION = new DDictEntry(113, 33, 20, "InteleViewer Markup Distance Calibration", null);
    public static final Map DICTIONARY = new TreeMap();
    private static final int PRIVATE_BLOCK_MIN = 16;
    private static final int PRIVATE_BLOCK_MAX = 255;
    private static final int PRIVATE_ELEMENT_MIN = 0;
    private static final int PRIVATE_ELEMENT_MAX = 255;
    private static final int SIZE_OF_DICOM_DOUBLE = 8;
    private static final int SIZE_OF_DICOM_LONG = 4;
    private static final int SIZE_OF_DICOM_SHORT = 2;
    private int mTransferSyntax;
    private int mNumberOfSubitems;

    private static void addEntryToDictionary(DDictEntry dDictEntry) {
        Map map = (Map)DICTIONARY.get(new Integer(dDictEntry.getGroup()));
        map.put(new Integer(dDictEntry.getElement()), dDictEntry);
    }

    public PrivateElement(int n2, int n3) {
        this.mTransferSyntax = n2;
        this.mNumberOfSubitems = n3;
    }

    public static String getImsGroupNumber(DicomObject dicomObject) throws DicomException {
        return PrivateElement.getPrivateString(dicomObject, IMS_GROUP_NUMBER);
    }

    public static void setImsGroupNumber(DicomObject dicomObject, String string, boolean bl2) throws DicomException {
        PrivateElement.setPrivateString(dicomObject, IMS_GROUP_NUMBER, string, bl2);
    }

    public static void deleteImsGroupNumber(DicomObject dicomObject) throws DicomException {
        PrivateElement.deletePrivateElement(dicomObject, IMS_GROUP_NUMBER);
    }

    public static String getImsInstitution(DicomObject dicomObject) throws DicomException {
        return PrivateElement.getPrivateString(dicomObject, IMS_INSTITUTION);
    }

    public static void setImsInstitution(DicomObject dicomObject, String string, boolean bl2) throws DicomException {
        PrivateElement.setPrivateString(dicomObject, IMS_INSTITUTION, string, bl2);
    }

    public static void deleteImsInstitution(DicomObject dicomObject) throws DicomException {
        PrivateElement.deletePrivateElement(dicomObject, IMS_INSTITUTION);
    }

    public static String getImsDestination(DicomObject dicomObject) throws DicomException {
        return PrivateElement.getPrivateString(dicomObject, IMS_AE_TITLE_DESTINATION);
    }

    public static void setImsDestination(DicomObject dicomObject, String string, boolean bl2) throws DicomException {
        PrivateElement.setPrivateString(dicomObject, IMS_AE_TITLE_DESTINATION, string, bl2);
    }

    public static void deleteImsDestination(DicomObject dicomObject) throws DicomException {
        PrivateElement.deletePrivateElement(dicomObject, IMS_AE_TITLE_DESTINATION);
    }

    public static String getImsSourceAeTitle(DicomObject dicomObject) throws DicomException {
        return PrivateElement.getPrivateString(dicomObject, IMS_SOURCE_AE_TITLE);
    }

    public static void setImsSourceAeTitle(DicomObject dicomObject, String string, boolean bl2) throws DicomException {
        PrivateElement.setPrivateString(dicomObject, IMS_SOURCE_AE_TITLE, string, bl2);
    }

    public static void deleteImsSourceAeTitle(DicomObject dicomObject) throws DicomException {
        PrivateElement.deletePrivateElement(dicomObject, IMS_SOURCE_AE_TITLE);
    }

    public static String getImsIvSourceName(DicomObject dicomObject) throws DicomException {
        return PrivateElement.getPrivateString(dicomObject, IMS_IV_SOURCE_NAME);
    }

    public static void setImsIvSourceName(DicomObject dicomObject, String string, boolean bl2) throws DicomException {
        PrivateElement.setPrivateString(dicomObject, IMS_IV_SOURCE_NAME, string, bl2);
    }

    public static void deleteImsIvSourceName(DicomObject dicomObject) throws DicomException {
        PrivateElement.deletePrivateElement(dicomObject, IMS_IV_SOURCE_NAME);
    }

    public static String getImsOwner(DicomObject dicomObject) throws DicomException {
        return PrivateElement.getPrivateString(dicomObject, IMS_SERIES_OWNER);
    }

    public static void setImsOwner(DicomObject dicomObject, String string, boolean bl2) throws DicomException {
        PrivateElement.setPrivateString(dicomObject, IMS_SERIES_OWNER, string, bl2);
    }

    public static void deleteImsOwner(DicomObject dicomObject) throws DicomException {
        PrivateElement.deletePrivateElement(dicomObject, IMS_SERIES_OWNER);
    }

    public static boolean getImsDeferredValidation(DicomObject dicomObject) throws DicomException {
        return "true".equals(PrivateElement.getPrivateString(dicomObject, IMS_DEFERRED_VALIDATION));
    }

    public static void setImsDeferredValidation(DicomObject dicomObject, boolean bl2, boolean bl3) throws DicomException {
        PrivateElement.setPrivateString(dicomObject, IMS_DEFERRED_VALIDATION, bl2 ? "true" : "false", bl3);
    }

    public static void deleteImsDeferredValidation(DicomObject dicomObject) throws DicomException {
        PrivateElement.deletePrivateElement(dicomObject, IMS_DEFERRED_VALIDATION);
    }

    public double getImsImageBytesTransferred(DicomObject dicomObject, int n2) throws DicomException {
        return this.getPrivateDouble(dicomObject, IMS_IMAGE_BYTES_TRANSFERRED, n2);
    }

    public void setImsImageBytesTransferred(DicomObject dicomObject, double d2, int n2) throws DicomException {
        this.setPrivateDouble(dicomObject, IMS_IMAGE_BYTES_TRANSFERRED, d2, n2);
    }

    public static void deleteImsImageBytesTransferred(DicomObject dicomObject) throws DicomException {
        PrivateElement.deletePrivateElement(dicomObject, IMS_IMAGE_BYTES_TRANSFERRED);
    }

    public int getImsHistogramPercentiles(DicomObject dicomObject, int n2) throws DicomException {
        return this.getPrivateUnsignedShort(dicomObject, IMS_HISTOGRAM_PERCENTILES, n2);
    }

    public void setImsHistogramPercentiles(DicomObject dicomObject, int n2, int n3) throws DicomException {
        this.setPrivateUnsignedShort(dicomObject, IMS_HISTOGRAM_PERCENTILES, n2, n3);
    }

    public static void deleteImsHistogramPercentiles(DicomObject dicomObject) throws DicomException {
        PrivateElement.deletePrivateElement(dicomObject, IMS_HISTOGRAM_PERCENTILES);
    }

    public double getImsHistogramPercentileValues(DicomObject dicomObject, int n2) throws DicomException {
        return this.getPrivateDouble(dicomObject, IMS_HISTOGRAM_PERCENTILE_VALUES, n2);
    }

    public void setImsHistogramPercentileValues(DicomObject dicomObject, double d2, int n2) throws DicomException {
        this.setPrivateDouble(dicomObject, IMS_HISTOGRAM_PERCENTILE_VALUES, d2, n2);
    }

    public static void deleteImsHistogramPercentileValues(DicomObject dicomObject) throws DicomException {
        PrivateElement.deletePrivateElement(dicomObject, IMS_HISTOGRAM_PERCENTILE_VALUES);
    }

    public double getImsImageQuality(DicomObject dicomObject, int n2) throws DicomException {
        return this.getPrivateDouble(dicomObject, IMS_IMAGE_QUALITY, n2);
    }

    public void setImsImageQuality(DicomObject dicomObject, double d2, int n2) throws DicomException {
        this.setPrivateDouble(dicomObject, IMS_IMAGE_QUALITY, d2, n2);
    }

    public static void deleteImsImageQuality(DicomObject dicomObject) throws DicomException {
        PrivateElement.deletePrivateElement(dicomObject, IMS_IMAGE_QUALITY);
    }

    public double getImsImageCompressionFraction(DicomObject dicomObject, int n2) throws DicomException {
        return this.getPrivateDouble(dicomObject, IMS_IMAGE_COMPRESSION_FRACTION, n2);
    }

    public void setImsImageCompressionFraction(DicomObject dicomObject, double d2, int n2) throws DicomException {
        this.setPrivateDouble(dicomObject, IMS_IMAGE_COMPRESSION_FRACTION, d2, n2);
    }

    public static void deleteImsCompressionFraction(DicomObject dicomObject) throws DicomException {
        PrivateElement.deletePrivateElement(dicomObject, IMS_IMAGE_COMPRESSION_FRACTION);
    }

    public static boolean getImsStrippedPixelData(DicomObject dicomObject) throws DicomException {
        String string = PrivateElement.getPrivateString(dicomObject, IMS_STRIPPED_PIXEL_DATA);
        return "true".equals(string);
    }

    public static void setImsStrippedPixelData(DicomObject dicomObject, boolean bl2, boolean bl3) throws DicomException {
        PrivateElement.setPrivateString(dicomObject, IMS_STRIPPED_PIXEL_DATA, bl2 ? "true" : "false", bl3);
    }

    public static void deleteImsStrippedPixelData(DicomObject dicomObject) throws DicomException {
        PrivateElement.deletePrivateElement(dicomObject, IMS_STRIPPED_PIXEL_DATA);
    }

    public static String getPrivateString(DicomObject dicomObject, DDictEntry dDictEntry) throws DicomException {
        return PrivateElement.getPrivateString(dicomObject, dDictEntry.getGroup(), dDictEntry.getElement());
    }

    public static String getPrivateString(DicomObject dicomObject, int n2, int n3) throws DicomException {
        int n4 = PrivateElement.findImsPrivateBlock(dicomObject, n2);
        if (n4 < 0) {
            return null;
        }
        n3 = n4 << 8 | n3 & 0xFF;
        return PrivateElement.getDicomString(dicomObject, n2, n3);
    }

    public static int getPrivateByte(DicomObject dicomObject, DDictEntry dDictEntry, int n2) throws DicomException {
        return PrivateElement.getPrivateByte(dicomObject, dDictEntry.getGroup(), dDictEntry.getElement(), n2);
    }

    public static int getPrivateByte(DicomObject dicomObject, int n2, int n3, int n4) throws DicomException {
        int n5 = PrivateElement.findImsPrivateBlock(dicomObject, n2);
        if (n5 < 0) {
            return Integer.MAX_VALUE;
        }
        n3 = n5 << 8 | n3 & 0xFF;
        return PrivateElement.getDicomByte(dicomObject, n2, n3, n4);
    }

    public int getPrivateUnsignedShort(DicomObject dicomObject, DDictEntry dDictEntry, int n2) throws DicomException {
        return this.getPrivateUnsignedShort(dicomObject, dDictEntry.getGroup(), dDictEntry.getElement(), n2);
    }

    public int getPrivateUnsignedShort(DicomObject dicomObject, int n2, int n3, int n4) throws DicomException {
        int n5 = PrivateElement.findImsPrivateBlock(dicomObject, n2);
        if (n5 < 0) {
            return Integer.MAX_VALUE;
        }
        n3 = n5 << 8 | n3 & 0xFF;
        return this.getDicomUnsignedShort(dicomObject, n2, n3, n4);
    }

    public int getPrivateSignedInteger(DicomObject dicomObject, DDictEntry dDictEntry, int n2) throws DicomException {
        return this.getPrivateSignedInteger(dicomObject, dDictEntry.getGroup(), dDictEntry.getElement(), n2);
    }

    private int getPrivateSignedInteger(DicomObject dicomObject, int n2, int n3, int n4) throws DicomException {
        int n5 = PrivateElement.findImsPrivateBlock(dicomObject, n2);
        if (n5 < 0) {
            return Integer.MAX_VALUE;
        }
        n3 = n5 << 8 | n3 & 0xFF;
        return this.getDicomSignedLong(dicomObject, n2, n3, n4);
    }

    public double getPrivateDouble(DicomObject dicomObject, DDictEntry dDictEntry, int n2) throws DicomException {
        return this.getPrivateDouble(dicomObject, dDictEntry.getGroup(), dDictEntry.getElement(), n2);
    }

    public double getPrivateDouble(DicomObject dicomObject, int n2, int n3, int n4) throws DicomException {
        int n5 = PrivateElement.findImsPrivateBlock(dicomObject, n2);
        if (n5 < 0) {
            return Double.MAX_VALUE;
        }
        n3 = n5 << 8 | n3 & 0xFF;
        return this.getDicomDouble(dicomObject, n2, n3, n4);
    }

    public static void setPrivateString(DicomObject dicomObject, DDictEntry dDictEntry, String string, boolean bl2) throws DicomException {
        PrivateElement.setPrivateString(dicomObject, dDictEntry.getGroup(), dDictEntry.getElement(), string, bl2);
    }

    public static void setPrivateString(DicomObject dicomObject, int n2, int n3, String string, boolean bl2) throws DicomException {
        int n4 = PrivateElement.findImsPrivateBlock(dicomObject, n2);
        if (n4 < 0) {
            n4 = PrivateElement.createImsPrivateBlock(dicomObject, n2);
        }
        n3 = n4 << 8 | n3 & 0xFF;
        if (bl2 || dicomObject.get_ge(n2, n3) == null) {
            dicomObject.set_ge(n2, n3, (Object)string);
        }
    }

    public void setPrivateByte(DicomObject dicomObject, DDictEntry dDictEntry, byte by2, int n2) throws DicomException {
        this.setPrivateByte(dicomObject, dDictEntry.getGroup(), dDictEntry.getElement(), by2, n2);
    }

    public void setPrivateByte(DicomObject dicomObject, int n2, int n3, byte by2, int n4) throws DicomException {
        int n5 = PrivateElement.findImsPrivateBlock(dicomObject, n2);
        if (n5 < 0) {
            n5 = PrivateElement.createImsPrivateBlock(dicomObject, n2);
        }
        n3 = n5 << 8 | n3 & 0xFF;
        this.setDicomByte(dicomObject, n2, n3, by2, n4);
    }

    public void setPrivateDouble(DicomObject dicomObject, DDictEntry dDictEntry, double d2, int n2) throws DicomException {
        this.setPrivateDouble(dicomObject, dDictEntry.getGroup(), dDictEntry.getElement(), d2, n2);
    }

    public void setPrivateDouble(DicomObject dicomObject, int n2, int n3, double d2, int n4) throws DicomException {
        int n5 = PrivateElement.findImsPrivateBlock(dicomObject, n2);
        if (n5 < 0) {
            n5 = PrivateElement.createImsPrivateBlock(dicomObject, n2);
        }
        n3 = n5 << 8 | n3 & 0xFF;
        this.setDicomDouble(dicomObject, n2, n3, d2, n4);
    }

    public void setPrivateUnsignedShort(DicomObject dicomObject, DDictEntry dDictEntry, int n2, int n3) throws DicomException {
        this.setPrivateUnsignedShort(dicomObject, dDictEntry.getGroup(), dDictEntry.getElement(), n2, n3);
    }

    public void setPrivateUnsignedShort(DicomObject dicomObject, int n2, int n3, int n4, int n5) throws DicomException {
        int n6 = PrivateElement.findImsPrivateBlock(dicomObject, n2);
        if (n6 < 0) {
            n6 = PrivateElement.createImsPrivateBlock(dicomObject, n2);
        }
        n3 = n6 << 8 | n3 & 0xFF;
        this.setDicomUnsignedShort(dicomObject, n2, n3, n4, n5);
    }

    public void setPrivateSignedInteger(DicomObject dicomObject, DDictEntry dDictEntry, int n2, int n3) throws DicomException {
        this.setPrivateSignedInteger(dicomObject, dDictEntry.getGroup(), dDictEntry.getElement(), n2, n3);
    }

    public void setPrivateSignedInteger(DicomObject dicomObject, int n2, int n3, int n4, int n5) throws DicomException {
        int n6 = PrivateElement.findImsPrivateBlock(dicomObject, n2);
        if (n6 < 0) {
            n6 = PrivateElement.createImsPrivateBlock(dicomObject, n2);
        }
        n3 = n6 << 8 | n3 & 0xFF;
        this.setDicomSignedLong(dicomObject, n2, n3, n4, n5);
    }

    public static void deletePrivateElement(DicomObject dicomObject, DDictEntry dDictEntry) throws DicomException {
        PrivateElement.deletePrivateElement(dicomObject, dDictEntry.getGroup(), dDictEntry.getElement());
    }

    public static void deletePrivateElement(DicomObject dicomObject, int n2, int n3) throws DicomException {
        int n4 = PrivateElement.findImsPrivateBlock(dicomObject, n2);
        if (n4 < 0) {
            return;
        }
        n3 = n4 << 8 | n3 & 0xFF;
        dicomObject.deleteItem_ge(n2, n3);
    }

    private static int findImsPrivateBlock(DicomObject dicomObject, int n2) throws DicomException {
        for (int i2 = 16; i2 <= 255; ++i2) {
            String string = PrivateElement.getDicomString(dicomObject, n2, i2);
            if (!IMS_BLOCK_NAME.equals(string)) continue;
            return i2;
        }
        return -1;
    }

    private static int createImsPrivateBlock(DicomObject dicomObject, int n2) throws DicomException {
        for (int i2 = 16; i2 <= 255; ++i2) {
            if (!PrivateElement.isBlockAvailable(dicomObject, n2, i2)) continue;
            dicomObject.set_ge(n2, i2, (Object)IMS_BLOCK_NAME);
            return i2;
        }
        throw new DicomException("No empty slots for private tags.");
    }

    private static boolean isBlockAvailable(DicomObject dicomObject, int n2, int n3) throws DicomException {
        String string = PrivateElement.getDicomString(dicomObject, n2, n3);
        if (string != null) {
            return false;
        }
        for (int i2 = 0; i2 < 255; ++i2) {
            int n4 = n3 << 8 | i2 & 0xFF;
            if (dicomObject.get_ge(n2, n4) == null) continue;
            return false;
        }
        return true;
    }

    private static String getDicomString(DicomObject dicomObject, int n2, int n3) throws DicomException {
        Object object = dicomObject.get_ge(n2, n3);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return PrivateElement.dicomTrimTrailingSpace(new String((byte[])object));
        }
        if (object instanceof String) {
            return PrivateElement.dicomTrimTrailingSpace((String)object);
        }
        throw new DicomException("Unknown object type returned from getDicomTag(" + n2 + "," + n3 + "). Class is " + object.getClass().toString());
    }

    private static String dicomTrimTrailingSpace(String string) {
        if (string != null) {
            return StringStrip.trailing(string, ' ');
        }
        return string;
    }

    private int getDicomUnsignedShort(DicomObject dicomObject, int n2, int n3, int n4) {
        int n5 = Integer.MAX_VALUE;
        Object object = dicomObject.get_ge(n2, n3, 0);
        if (object == null) {
            return n5;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (n4 * 2 < byArray.length) {
                n5 = this.readUnsignedShortFromByteArray(byArray, n4);
            }
        } else if (object instanceof Integer) {
            n5 = (Integer)dicomObject.get_ge(n2, n3, n4) & 0xFFFF;
        }
        return n5;
    }

    private void setDicomUnsignedShort(DicomObject dicomObject, int n2, int n3, int n4, int n5) throws DicomException {
        Object object = dicomObject.get_ge(n2, n3, 0);
        if (object == null) {
            int n6 = DDict.getTypeCode((int)n2, (int)n3);
            if (n6 == 0) {
                byte[] byArray = new byte[this.mNumberOfSubitems * 2];
                for (int i2 = 0; i2 < this.mNumberOfSubitems; ++i2) {
                    this.writeUnsignedShortToByteArray(byArray, 0, i2);
                }
                dicomObject.set_ge(n2, n3, (Object)byArray);
                object = byArray;
            } else {
                for (int i3 = 0; i3 < this.mNumberOfSubitems; ++i3) {
                    dicomObject.set_ge(n2, n3, (Object)new Integer(0), i3);
                }
            }
        }
        if (object instanceof byte[]) {
            this.writeUnsignedShortToByteArray((byte[])object, n4, n5);
        } else {
            dicomObject.set_ge(n2, n3, (Object)new Integer(n4), n5);
        }
    }

    int getDicomSignedLong(DicomObject dicomObject, int n2, int n3, int n4) {
        int n5 = Integer.MAX_VALUE;
        Object object = dicomObject.get_ge(n2, n3, 0);
        if (object == null) {
            return n5;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (n4 * 4 < byArray.length) {
                n5 = this.readSignedLongFromByteArray(byArray, n4);
            }
        } else if (object instanceof Long) {
            n5 = ((Long)dicomObject.get_ge(n2, n3, n4)).intValue();
        }
        return n5;
    }

    private void setDicomSignedLong(DicomObject dicomObject, int n2, int n3, int n4, int n5) throws DicomException {
        Object object = dicomObject.get_ge(n2, n3, 0);
        if (object == null) {
            int n6 = DDict.getTypeCode((int)n2, (int)n3);
            if (n6 == 0) {
                byte[] byArray = new byte[this.mNumberOfSubitems * 4];
                for (int i2 = 0; i2 < this.mNumberOfSubitems; ++i2) {
                    this.writeSignedLongToByteArray(byArray, 0, i2);
                }
                dicomObject.set_ge(n2, n3, (Object)byArray);
                object = byArray;
            } else {
                for (int i3 = 0; i3 < this.mNumberOfSubitems; ++i3) {
                    dicomObject.set_ge(n2, n3, (Object)new Long(0L), i3);
                }
            }
        }
        if (object instanceof byte[]) {
            this.writeSignedLongToByteArray((byte[])object, n4, n5);
        } else {
            dicomObject.set_ge(n2, n3, (Object)new Long(n4), n5);
        }
    }

    private static int getDicomByte(DicomObject dicomObject, int n2, int n3, int n4) throws DicomException {
        Object object = dicomObject.get_ge(n2, n3, 0);
        if (object == null) {
            return Integer.MAX_VALUE;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray != null && byArray.length > n4) {
                return byArray[n4];
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        if (object instanceof String) {
            if (n4 > 0) {
                object = dicomObject.get_ge(n2, n3, n4);
            }
            return Byte.parseByte((String)object);
        }
        throw new DicomException("Unknown object type returned from getDicomTag(" + n2 + "," + n3 + "). Class is " + object.getClass().toString());
    }

    private void setDicomByte(DicomObject dicomObject, int n2, int n3, byte by2, int n4) throws DicomException {
        Object object = dicomObject.get_ge(n2, n3, 0);
        if (object == null) {
            int n5 = (this.mNumberOfSubitems + 1) / 2 * 2;
            byte[] byArray = new byte[n5];
            for (int i2 = 0; i2 < n5; ++i2) {
                byArray[i2] = 0;
            }
            dicomObject.set_ge(n2, n3, (Object)byArray);
            object = byArray;
        }
        if (!(object instanceof byte[])) {
            throw new DicomException(" Unknown object type: " + object.getClass().toString() + " retuned from DicomObject.get_ge(" + n2 + "," + n3 + ")");
        }
        byte[] byArray = (byte[])object;
        byArray[n4] = by2;
    }

    private double getDicomDouble(DicomObject dicomObject, int n2, int n3, int n4) {
        double d2 = Double.MAX_VALUE;
        Object object = dicomObject.get_ge(n2, n3, 0);
        if (object == null) {
            return d2;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (n4 * 8 < byArray.length) {
                d2 = this.readDoubleFromByteArray(byArray, n4);
            }
        } else if (object instanceof Double) {
            d2 = (Double)dicomObject.get_ge(n2, n3, n4);
        }
        return d2;
    }

    private void setDicomDouble(DicomObject dicomObject, int n2, int n3, double d2, int n4) throws DicomException {
        Object object = dicomObject.get_ge(n2, n3, 0);
        if (object == null) {
            int n5 = DDict.getTypeCode((int)n2, (int)n3);
            if (n5 == 0) {
                byte[] byArray = new byte[this.mNumberOfSubitems * 8];
                for (int i2 = 0; i2 < this.mNumberOfSubitems; ++i2) {
                    this.writeDoubleToByteArray(byArray, 0.0, i2);
                }
                dicomObject.set_ge(n2, n3, (Object)byArray);
                object = byArray;
            } else {
                for (int i3 = 0; i3 < this.mNumberOfSubitems; ++i3) {
                    dicomObject.set_ge(n2, n3, (Object)new Double(0.0), i3);
                }
            }
        }
        if (object instanceof byte[]) {
            this.writeDoubleToByteArray((byte[])object, d2, n4);
        } else {
            dicomObject.set_ge(n2, n3, (Object)new Double(d2), n4);
        }
    }

    private int readUnsignedShortFromByteArray(byte[] byArray, int n2) {
        return this.readIntegerFromArray(byArray, 2, n2);
    }

    private int readSignedLongFromByteArray(byte[] byArray, int n2) {
        return this.readIntegerFromArray(byArray, 4, n2);
    }

    private int readIntegerFromArray(byte[] byArray, int n2, int n3) {
        int n4 = n3 * n2;
        boolean bl2 = this.mTransferSyntax == 8195;
        int n5 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n6 = bl2 ? n2 - 1 - i2 : i2;
            n5 |= (byArray[n4 + i2] & 0xFF) << (n6 *= 8);
        }
        return n5;
    }

    private void writeUnsignedShortToByteArray(byte[] byArray, int n2, int n3) {
        this.writeIntegerToByteArray(byArray, 2, n2, n3);
    }

    private void writeSignedLongToByteArray(byte[] byArray, int n2, int n3) {
        this.writeIntegerToByteArray(byArray, 4, n2, n3);
    }

    private void writeIntegerToByteArray(byte[] byArray, int n2, int n3, int n4) {
        int n5 = n4 * n2;
        boolean bl2 = this.mTransferSyntax == 8195;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n6 = bl2 ? n2 - 1 - i2 : i2;
            byArray[n5 + i2] = (byte)(n3 >>> (n6 *= 8));
        }
    }

    private double readDoubleFromByteArray(byte[] byArray, int n2) {
        int n3 = n2 * 8;
        boolean bl2 = this.mTransferSyntax == 8195;
        long l2 = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            int n4 = bl2 ? 7 - i2 : i2;
            l2 |= (long)(byArray[n3 + i2] & 0xFF) << (n4 *= 8);
        }
        return Double.longBitsToDouble(l2);
    }

    private void writeDoubleToByteArray(byte[] byArray, double d2, int n2) {
        int n3 = n2 * 8;
        long l2 = Double.doubleToLongBits(d2);
        boolean bl2 = this.mTransferSyntax == 8195;
        for (int i2 = 0; i2 < 8; ++i2) {
            int n4 = bl2 ? 7 - i2 : i2;
            byArray[n3 + i2] = (byte)(l2 >>> (n4 *= 8));
        }
    }

    public static boolean getImsDelayedMoveRequest(DicomObject dicomObject) throws DicomException {
        String string = PrivateElement.getPrivateString(dicomObject, IMS_DELAYED_MOVE_REQUEST);
        return "true".equals(string);
    }

    public static void setImsDelayedMoveRequest(DicomObject dicomObject, boolean bl2, boolean bl3) throws DicomException {
        PrivateElement.setPrivateString(dicomObject, IMS_DELAYED_MOVE_REQUEST, bl2 ? "true" : "false", bl3);
    }

    public static void deleteImsDelayedMoveRequest(DicomObject dicomObject) throws DicomException {
        PrivateElement.deletePrivateElement(dicomObject, IMS_DELAYED_MOVE_REQUEST);
    }

    public static DDictEntry findDictionaryEntry(int n2, int n3) {
        Map map = (Map)DICTIONARY.get(new Integer(n2));
        if (map == null) {
            return null;
        }
        return (DDictEntry)map.get(new Integer(n3 & 0xFF));
    }

    static {
        DICTIONARY.put(new Integer(16129), new TreeMap());
        DICTIONARY.put(new Integer(41), new TreeMap());
        DICTIONARY.put(new Integer(16131), new TreeMap());
        DICTIONARY.put(new Integer(16133), new TreeMap());
        DICTIONARY.put(new Integer(113), new TreeMap());
        PrivateElement.addEntryToDictionary(IMS_INSTITUTION);
        PrivateElement.addEntryToDictionary(IMS_AE_TITLE_DESTINATION);
        PrivateElement.addEntryToDictionary(IMS_SOURCE_AE_TITLE);
        PrivateElement.addEntryToDictionary(IMS_DEFERRED_VALIDATION);
        PrivateElement.addEntryToDictionary(IMS_SERIES_OWNER);
        PrivateElement.addEntryToDictionary(IMS_GROUP_NUMBER);
        PrivateElement.addEntryToDictionary(IMS_STRIPPED_PIXEL_DATA);
        PrivateElement.addEntryToDictionary(IMS_ASSOCIATION_DATE);
        PrivateElement.addEntryToDictionary(IMS_ASSOCIATION_TIME);
        PrivateElement.addEntryToDictionary(IMS_IMAGE_COMPRESSION_FRACTION);
        PrivateElement.addEntryToDictionary(IMS_IMAGE_QUALITY);
        PrivateElement.addEntryToDictionary(IMS_IMAGE_BYTES_TRANSFERRED);
        PrivateElement.addEntryToDictionary(IMS_J2C_PARAMETER_TYPE);
        PrivateElement.addEntryToDictionary(IMS_J2C_PIXEL_REPRESENTATION);
        PrivateElement.addEntryToDictionary(IMS_J2C_BITS_ALLOCATED);
        PrivateElement.addEntryToDictionary(IMS_J2C_PIXEL_SHIFT_VALUE);
        PrivateElement.addEntryToDictionary(IMS_J2C_PLANAR_CONFIGURATION);
        PrivateElement.addEntryToDictionary(IMS_J2C_RESCALE_INTERCEPT);
        PrivateElement.addEntryToDictionary(IMS_PIXEL_DATA_MD5SUM);
        PrivateElement.addEntryToDictionary(IMS_HISTOGRAM_PERCENTILES);
        PrivateElement.addEntryToDictionary(IMS_HISTOGRAM_PERCENTILE_VALUES);
        PrivateElement.addEntryToDictionary(IMS_ATTRIBUTE_HISTORY);
        PrivateElement.addEntryToDictionary(IMS_ATTRIBUTE_HISTORY_TIMESTAMP);
        PrivateElement.addEntryToDictionary(IMS_ATTRIBUTE_HISTORY_CHANGE_INITIATOR);
        PrivateElement.addEntryToDictionary(IMS_ATTRIBUTE_HISTORY_CHANGE_EXPLANATION);
        PrivateElement.addEntryToDictionary(IMS_IV_SOURCE_NAME);
        PrivateElement.addEntryToDictionary(IMS_IV_MARKUP_TYPE);
        PrivateElement.addEntryToDictionary(IMS_IV_MARKUP_TEXT);
        PrivateElement.addEntryToDictionary(IMS_IV_MARKUP_TEXT_OFFSET);
        PrivateElement.addEntryToDictionary(IMS_IV_MARKUP_POSITION);
        PrivateElement.addEntryToDictionary(IMS_IV_MARKUP_HALF_VECTOR);
        PrivateElement.addEntryToDictionary(IMS_IV_MARKUP_VECTOR1);
        PrivateElement.addEntryToDictionary(IMS_IV_MARKUP_VECTOR2);
        PrivateElement.addEntryToDictionary(IMS_IV_MARKUP_ORTHOGONAL_POSITION);
        PrivateElement.addEntryToDictionary(IMS_IV_MARKUP_ORTHOGONAL_HALF_VECTOR);
        PrivateElement.addEntryToDictionary(IMS_IV_MARKUP_DATASET_TOOL_ID);
        PrivateElement.addEntryToDictionary(IMS_IV_MARKUP_DISTANCE_CALIBRATION);
    }
}

