/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.serialization.protocol;

import RuntimeTool.Debug;
import RuntimeTool.DebugManager;
import StringUtilities.ToString;
import com.intelerad.lib.serialization.exception.ServiceException;
import com.intelerad.lib.serialization.protocol.Protocol;
import com.intelerad.lib.serialization.protocol.negotiation.ProtocolProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ProtocolCatalog
implements ProtocolProvider {
    private static final ProtocolCatalog mInstance = new ProtocolCatalog();
    private Map mProtocolMap = new HashMap();

    private ProtocolCatalog() {
    }

    public static ProtocolCatalog getInstance() {
        return mInstance;
    }

    public void addProtocol(Protocol protocol) {
        this.mProtocolMap.put(protocol.getMajorVersion(), protocol);
    }

    public Protocol getProtocol(String string) {
        return (Protocol)this.mProtocolMap.get(this.getProtocolMajorVersion(string));
    }

    public boolean containsProtocol(String string) {
        return this.mProtocolMap.containsKey(this.getProtocolMajorVersion(string));
    }

    private String getProtocolMajorVersion(String string) {
        if (string == null) {
            return null;
        }
        return string.substring(0, string.indexOf(46));
    }

    public Set getProtocols() throws ServiceException {
        Debug debug = DebugManager.getDefault();
        debug.printTrace("Service method called: service [ProtocolProvider], method [getProtocols], service implementation class [ProtocolCatalog]");
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.mProtocolMap.values().iterator();
        while (iterator.hasNext()) {
            Protocol protocol = (Protocol)iterator.next();
            hashSet.add(protocol.getName());
        }
        debug.printTrace("Returning set of protocols " + ToString.set(hashSet));
        return hashSet;
    }
}

