/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.systemutilities.lib;

import RuntimeTool.Debug;
import RuntimeTool.DebugManager;
import StringUtilities.StringEncoder;
import com.intelerad.lib.process.CommandLauncher;
import java.io.File;
import javax.swing.JFrame;

public class SystemUtilities {
    public static final String JNI_LIBNAME = "intelerad.jni.libname";
    public static final String DEFAULT_LIBNAME = "SystemUtilitiesJNI";
    private static boolean mAlreadyInitialized;

    public static synchronized void initialize() {
        if (mAlreadyInitialized) {
            return;
        }
        String string = System.getProperty(JNI_LIBNAME);
        if (string == null) {
            string = DEFAULT_LIBNAME;
        }
        System.loadLibrary(string);
        mAlreadyInitialized = true;
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string != null && string.toUpperCase().startsWith("WINDOWS");
    }

    public static native long getFreeDiskSpace(String var0);

    public static native long getTotalDiskSpace(String var0);

    public static native long getVirtualMemoryAvailable();

    public static native long getClusterSize(String var0);

    public static native boolean isAdmin();

    public static native String getSystemDrive();

    public static double getDiskUsageFraction(String string) {
        long l2 = SystemUtilities.getTotalDiskSpace(string);
        if (l2 <= 0L) {
            return 1.0;
        }
        return 1.0 - (double)SystemUtilities.getFreeDiskSpace(string) / (double)l2;
    }

    public static boolean grantFullAccess(File file) {
        if (!file.exists()) {
            return false;
        }
        String[] stringArray = SystemUtilities.isWindows() ? new String[]{"cacls", file.getAbsolutePath(), "/T", "/E", "/G", "Everyone:F"} : new String[]{"chmod", "-R", "777", file.getAbsolutePath()};
        CommandLauncher commandLauncher = new CommandLauncher("GrantFullAccess", stringArray);
        try {
            return commandLauncher.launch(null, DebugManager.getDefault()).waitFor() == 0;
        }
        catch (Exception exception) {
            DebugManager.getDefault().printException("Failed to grant full access using: " + commandLauncher, exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void moveToFront(JFrame jFrame) {
        long l2 = -1L;
        try {
            try {
                l2 = SystemUtilities.attachForegroundWindowThread();
            }
            catch (Throwable throwable) {
                DebugManager.getDefault().printException("Failed to call native attachWindowThread()", throwable);
            }
            jFrame.show();
            jFrame.toFront();
            Object var5_3 = null;
            if (l2 == -1L) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (l2 == -1L) throw throwable;
            try {
                SystemUtilities.detachThread(l2);
                throw throwable;
            }
            catch (Throwable throwable2) {
                DebugManager.getDefault().printException("Failed to call native detachThread()", throwable2);
            }
            throw throwable;
        }
        try {
            SystemUtilities.detachThread(l2);
            return;
        }
        catch (Throwable throwable) {
            DebugManager.getDefault().printException("Failed to call native detachThread()", throwable);
        }
    }

    private static native long attachForegroundWindowThread();

    private static native boolean detachThread(long var0);

    public static void logSystemInformation(Debug debug) {
        debug.printTrace(System.getProperty("os.name") + " OS, version " + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + " arch");
        debug.printTrace("Java version " + System.getProperty("java.version") + ", from " + System.getProperty("java.home"));
        debug.printTrace("OS username " + System.getProperty("user.name") + ", with user home directory at " + System.getProperty("user.home"));
        debug.printTrace("Default string encoding is " + StringEncoder.getDefaultStringEncoding());
    }

    public static void disableDirectDraw() {
        System.setProperty("sun.java2d.noddraw", "true");
    }

    static {
        try {
            SystemUtilities.initialize();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            DebugManager.getDefault().printDebug("Failed to load JNI, native methods will fail.");
        }
        mAlreadyInitialized = false;
    }
}

