/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.tools.lib.backgroundthread;

import DataStructures.DelayWorkQueue;
import com.intelerad.tools.lib.backgroundthread.BackgroundTask;
import com.intelerad.tools.lib.backgroundthread.BackgroundThreadExceptionHandler;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BackgroundTaskScheduler {
    private final String mThreadName;
    private final Set mOutstandingTasks = Collections.synchronizedSet(new HashSet());
    private final DelayWorkQueue mWorkQueue = new DelayWorkQueue();
    private final BackgroundThreadExceptionHandler mExceptionHandler;
    private boolean mThreadStarted = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BackgroundTaskScheduler(String string, BackgroundThreadExceptionHandler backgroundThreadExceptionHandler) {
        this.mThreadName = string;
        this.mExceptionHandler = backgroundThreadExceptionHandler;
    }

    public void schedule(BackgroundTask backgroundTask) {
        this.schedule(backgroundTask, 0L);
    }

    public void schedule(BackgroundTask backgroundTask, long l2) {
        if (this.mOutstandingTasks.add(backgroundTask.getId())) {
            this.mWorkQueue.addWork(backgroundTask, l2);
            this.startThread();
        }
    }

    public List getAllItems() {
        return this.mWorkQueue.getAllItems();
    }

    protected void processNextTask() {
        BackgroundTask backgroundTask = (BackgroundTask)this.mWorkQueue.getWork();
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            if (backgroundTask.isExpired()) {
                bl3 = true;
            } else if (!backgroundTask.execute()) {
                bl2 = true;
            }
        }
        catch (Throwable throwable) {
            bl3 = true;
            this.mExceptionHandler.reportTaskException(backgroundTask, throwable);
        }
        if (!$assertionsDisabled && bl3 && bl2) {
            throw new AssertionError();
        }
        try {
            if (bl3) {
                backgroundTask.cleanUp();
            }
        }
        catch (Throwable throwable) {
            this.mExceptionHandler.reportTaskException(backgroundTask, throwable);
        }
        if (bl2) {
            this.mWorkQueue.addWork(backgroundTask, backgroundTask.getRetryPeriod());
        } else {
            this.mOutstandingTasks.remove(backgroundTask.getId());
        }
    }

    protected synchronized void startThread() {
        if (this.mThreadStarted) {
            return;
        }
        Thread thread = new Thread((Runnable)new ProcessTasksRunnable(), this.mThreadName);
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
        this.mThreadStarted = true;
    }

    static {
        $assertionsDisabled = !BackgroundTaskScheduler.class.desiredAssertionStatus();
    }

    private class ProcessTasksRunnable
    implements Runnable {
        private ProcessTasksRunnable() {
        }

        public void run() {
            try {
                while (true) {
                    BackgroundTaskScheduler.this.processNextTask();
                }
            }
            catch (Throwable throwable) {
                BackgroundTaskScheduler.this.mExceptionHandler.reportThreadExit(throwable);
                return;
            }
        }
    }
}

