/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.tools.lib.concurrent;

import RuntimeTool.DebugManager;
import com.intelerad.tools.lib.concurrent.AsynchronousCallableBundle;
import com.intelerad.tools.lib.concurrent.BasicCompositeTaskController;
import com.intelerad.tools.lib.concurrent.CallAdapter;
import com.intelerad.tools.lib.concurrent.CallListener;
import com.intelerad.tools.lib.concurrent.Cancellable;
import com.intelerad.tools.lib.concurrent.CompositeCallListener;
import com.intelerad.tools.lib.concurrent.Invoker;
import com.intelerad.tools.lib.concurrent.TaskController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AsynchronousCallableExecutor {
    public static final int UNLIMITED = -1;
    private final List mAsynchronousCallableBundles;
    private int mCurrentIndex = 0;
    private final Map mCurrentTasks = new HashMap();
    private final int mConcurrency;
    private BasicCompositeTaskController mCompositeTaskController;

    public static TaskController doAllFunctions(List list, CompositeCallListener compositeCallListener, Invoker invoker) {
        return AsynchronousCallableExecutor.doAllFunctions(list, compositeCallListener, invoker, 1);
    }

    public static TaskController doAllFunctions(List list, CompositeCallListener compositeCallListener, Invoker invoker, int n2) {
        AsynchronousCallableExecutor asynchronousCallableExecutor = new AsynchronousCallableExecutor(list, compositeCallListener, invoker, n2);
        asynchronousCallableExecutor.start();
        return asynchronousCallableExecutor.getTaskController();
    }

    public AsynchronousCallableExecutor(List list, CompositeCallListener compositeCallListener, Invoker invoker, int n2) {
        this.mAsynchronousCallableBundles = new ArrayList(list);
        this.mConcurrency = n2 == -1 ? this.mAsynchronousCallableBundles.size() : n2;
        Cancellable cancellable = new Cancellable(){

            public void cancel() {
                AsynchronousCallableExecutor.this.cancelOutstanding();
            }
        };
        this.mCompositeTaskController = new BasicCompositeTaskController(cancellable, compositeCallListener, invoker);
    }

    public TaskController getTaskController() {
        return this.mCompositeTaskController;
    }

    public synchronized void start() {
        for (int i2 = 0; i2 < this.mConcurrency; ++i2) {
            this.startTask();
        }
        this.checkForDone();
    }

    private synchronized void taskFinished(CallListener callListener) {
        this.mCurrentTasks.remove(callListener);
        this.startTask();
        this.checkForDone();
    }

    private synchronized void checkForDone() {
        if (this.mCurrentTasks.size() == 0) {
            this.mCompositeTaskController.finished();
        }
    }

    private synchronized void startTask() {
        if (this.mCompositeTaskController.isCancelled()) {
            return;
        }
        if (this.mCurrentIndex >= this.mAsynchronousCallableBundles.size()) {
            return;
        }
        final AsynchronousCallableBundle asynchronousCallableBundle = (AsynchronousCallableBundle)this.mAsynchronousCallableBundles.get(this.mCurrentIndex);
        ++this.mCurrentIndex;
        CallAdapter callAdapter = new CallAdapter(){

            public void handleSuccess(Object object) {
                AsynchronousCallableExecutor.this.mCompositeTaskController.addPartialSuccess(object, asynchronousCallableBundle.getContext());
            }

            public void handleException(Exception exception) {
                AsynchronousCallableExecutor.this.mCompositeTaskController.addPartialException(exception, asynchronousCallableBundle.getContext());
            }

            public void handleFinally() {
                AsynchronousCallableExecutor.this.taskFinished(this);
            }
        };
        this.mCurrentTasks.put(callAdapter, asynchronousCallableBundle.getAsynchronousCallable().call(callAdapter));
    }

    private synchronized void cancelOutstanding() {
        Iterator iterator = this.mCurrentTasks.values().iterator();
        while (iterator.hasNext()) {
            try {
                ((TaskController)iterator.next()).cancel();
            }
            catch (Throwable throwable) {
                DebugManager.getDefault().printException("unexpected exception in cancel().", throwable);
            }
        }
    }
}

