/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.tools.lib.concurrent;

import com.intelerad.tools.lib.concurrent.AsynchronousCallable;
import com.intelerad.tools.lib.concurrent.CallListener;
import com.intelerad.tools.lib.concurrent.CancellationException;
import com.intelerad.tools.lib.concurrent.ExecutionException;
import com.intelerad.tools.lib.concurrent.TaskController;
import com.intelerad.tools.lib.concurrent.ThreadBlocker;

public class AsynchronousUtilities {
    public static Object blockForResult(AsynchronousCallable asynchronousCallable) throws ExecutionException, CancellationException {
        ThreadBlocker threadBlocker = new ThreadBlocker();
        ResultListener resultListener = new ResultListener(threadBlocker);
        TaskController taskController = asynchronousCallable.call(resultListener);
        try {
            threadBlocker.block();
        }
        catch (ThreadBlocker.CancelledBlockException cancelledBlockException) {
            taskController.cancel();
            throw new CancellationException();
        }
        if (resultListener.mCancelled) {
            throw new CancellationException();
        }
        if (resultListener.mException != null) {
            throw new ExecutionException(resultListener.mException);
        }
        return resultListener.mResult;
    }

    private static class ResultListener
    implements CallListener {
        Exception mException;
        Object mResult;
        boolean mCancelled;
        private final ThreadBlocker mBlocker;

        public ResultListener(ThreadBlocker threadBlocker) {
            this.mBlocker = threadBlocker;
        }

        public void handleCancel() {
            this.mCancelled = true;
        }

        public void handleException(Exception exception) {
            this.mException = exception;
        }

        public void handleFinally() {
            this.mBlocker.wakeup();
        }

        public void handleSuccess(Object object) {
            this.mResult = object;
        }
    }
}

