/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.tools.lib.html;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class HtmlUtils {
    private static final Pattern IS_HTML_REGEXP = Pattern.compile("</?[a-zA-Z]+>");
    private static final Pattern HTML_TAG_REGEXP = Pattern.compile("</?[a-zA-Z][^>]*>");

    public static String toHtml(Object object) {
        if (object == null) {
            return "";
        }
        String string = object.toString();
        if (StringUtils.isBlank((String)string)) {
            return "";
        }
        if (HtmlUtils.isEmptyHtml(string)) {
            return "";
        }
        if (HtmlUtils.isHtml(string)) {
            return string;
        }
        return "<html><head></head><body><pre>" + string + "</pre>" + "</body>" + "</html>";
    }

    private static boolean isHtml(String string) {
        return IS_HTML_REGEXP.matcher(string).find();
    }

    public static boolean isEmptyHtml(String string) {
        String string2 = HTML_TAG_REGEXP.matcher(string).replaceAll("");
        return StringUtils.isBlank((String)string2);
    }
}

