/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.viewer.dicomstorage.database;

import DataModels.ModelProperty;
import DataModels.ObservableDataModel;
import com.intelerad.datamodels.dicom.DicomAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DicomStorageDataModel
extends ObservableDataModel {
    private Map mMap;
    public static final ModelProperty SOURCE_AE_TITLE = new ModelProperty(class$java$lang$String == null ? (class$java$lang$String = DicomStorageDataModel.class$("java.lang.String")) : class$java$lang$String, "SourceAETitle", "Source Application Entity Title");
    public static final ModelProperty PERCENTILES = new ModelProperty(class$java$util$List == null ? (class$java$util$List = DicomStorageDataModel.class$("java.util.List")) : class$java$util$List, "Percentiles", "Percentiles");
    public static final ModelProperty LAST_INSTANCE_RECEIVE_DATE = new ModelProperty(class$java$util$Date == null ? (class$java$util$Date = DicomStorageDataModel.class$("java.util.Date")) : class$java$util$Date, "LastInstanceReceiveDate", "Last Instance Receive Date");
    private static final List PROPERTIES = Collections.unmodifiableList(Arrays.asList(DicomAttribute.StudyInstanceUID, DicomAttribute.PatientID, DicomAttribute.PatientName, DicomAttribute.PatientBirthDate, DicomAttribute.PatientBirthTime, DicomAttribute.PatientSex, DicomAttribute.PatientAge, DicomAttribute.StudyDate, DicomAttribute.StudyTime, DicomAttribute.AccessionNumber, DicomAttribute.StudyID, DicomAttribute.ReferringPhysiciansName, DicomAttribute.StudyDescription, DicomAttribute.NumberOfStudyRelatedSeries, DicomAttribute.ModalitiesInStudy, DicomAttribute.SeriesInstanceUID, DicomAttribute.StudyInstanceUID, DicomAttribute.Modality, DicomAttribute.SeriesNumber, DicomAttribute.ProtocolName, DicomAttribute.SeriesDescription, DicomAttribute.BodyPartExamined, DicomAttribute.ViewPosition, DicomAttribute.ScheduledProcedureStepID, DicomAttribute.Laterality, DicomAttribute.SeriesDate, DicomAttribute.SeriesTime, DicomAttribute.RequestedProcedureID, DicomAttribute.RequestAttributesSequence, DicomAttribute.PerformedProcedureStepStartDate, DicomAttribute.PerformedProcedureStepStartTime, DicomAttribute.NumberOfSeriesRelatedImages, DicomAttribute.SOPInstanceUID, DicomAttribute.Rows, DicomAttribute.Columns, DicomAttribute.WindowCenter, DicomAttribute.WindowWidth, DicomAttribute.PixelAspectRatio, DicomAttribute.ImagePositionPatient, DicomAttribute.ImageOrientationPatient, DicomAttribute.PixelSpacing, DicomAttribute.ImagerPixelSpacing, DicomAttribute.PatientOrientation, DicomAttribute.InstanceNumber, DicomAttribute.NumberOfFrames, DicomAttribute.PhotometricInterpretation, DicomAttribute.EchoNumber, DicomAttribute.RescaleSlope, DicomAttribute.RescaleIntercept, DicomAttribute.PixelRepresentation, DicomAttribute.PlanarConfiguration, DicomAttribute.BitsAllocated, DicomAttribute.BitsStored, DicomAttribute.HighBit, DicomAttribute.SmallestImagePixelValue, DicomAttribute.LargestImagePixelValue, DicomAttribute.FrameOfReferenceUID, SOURCE_AE_TITLE, PERCENTILES, LAST_INSTANCE_RECEIVE_DATE));
    private static final String[] PERCENTILES_KEYS = new String[]{"PercentilesP1", "PercentilesP5", "PercentilesP10", "PercentilesP90", "PercentilesP95", "PercentilesP99"};
    private static final String[] PIXEL_ASPECT_RATIO_KEYS = new String[]{"PixelAspectRatioHorizontal", "PixelAspectRatioVertical"};
    private static final String[] IMAGE_POSITION_PATIENT_KEYS = new String[]{"ImagePositionPatientX", "ImagePositionPatientY", "ImagePositionPatientZ"};
    private static final String[] IMAGE_ORIENTATION_PATIENT_KEYS = new String[]{"ImageOrientationPatientRowX", "ImageOrientationPatientRowY", "ImageOrientationPatientRowZ", "ImageOrientationPatientColumnX", "ImageOrientationPatientColumnY", "ImageOrientationPatientColumnZ"};
    private static final String[] PIXEL_SPACING_KEY = new String[]{"PixelSpacingRow", "PixelSpacingColumn"};
    private static final String[] IMAGER_PIXEL_SPACING_KEYS = new String[]{"ImagerPixelSpacingRow", "ImagerPixelSpacingColumn"};
    private static final String[] PATIENT_ORIENTATION_KEYS = new String[]{"PatientOrientationRow", "PatientOrientationColumn"};
    public static Class class$java$lang$String;
    public static Class class$java$util$List;
    public static Class class$java$util$Date;

    public DicomStorageDataModel(Map map) {
        this.mMap = map;
    }

    public void setProperty(ModelProperty modelProperty, Object object) throws IllegalArgumentException {
        this.mMap.put(modelProperty.getName(), object);
    }

    public Object getProperty(ModelProperty modelProperty) throws IllegalArgumentException {
        if (modelProperty == PERCENTILES) {
            return this.getListAllRequired(PERCENTILES_KEYS);
        }
        if (modelProperty == SOURCE_AE_TITLE) {
            return this.mMap.get(SOURCE_AE_TITLE.getName());
        }
        if (modelProperty == LAST_INSTANCE_RECEIVE_DATE) {
            return this.mMap.get(LAST_INSTANCE_RECEIVE_DATE.getName());
        }
        if (modelProperty == DicomAttribute.PixelAspectRatio) {
            return this.getListAllRequired(PIXEL_ASPECT_RATIO_KEYS);
        }
        if (modelProperty == DicomAttribute.ImagePositionPatient) {
            return this.getListAllRequired(IMAGE_POSITION_PATIENT_KEYS);
        }
        if (modelProperty == DicomAttribute.ImageOrientationPatient) {
            return this.getListAllRequired(IMAGE_ORIENTATION_PATIENT_KEYS);
        }
        if (modelProperty == DicomAttribute.PixelSpacing) {
            return this.getListAllRequired(PIXEL_SPACING_KEY);
        }
        if (modelProperty == DicomAttribute.ImagerPixelSpacing) {
            return this.getListAllRequired(IMAGER_PIXEL_SPACING_KEYS);
        }
        if (modelProperty == DicomAttribute.PatientOrientation) {
            return this.getListAllRequired(PATIENT_ORIENTATION_KEYS);
        }
        String string = modelProperty.getName();
        return this.translate(modelProperty, this.mMap.get(string));
    }

    public Collection getProperties() {
        return PROPERTIES;
    }

    private Object translate(ModelProperty modelProperty, Object object) {
        if (object == null) {
            return null;
        }
        if (modelProperty.getClass().equals(object.getClass())) {
            return object;
        }
        if (object instanceof List) {
            String string = "";
            List list = (List)object;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (string.length() != 0) {
                    string = string + ", ";
                }
                string = string + iterator.next();
            }
            return string;
        }
        if (modelProperty.getClass().equals(class$java$lang$String == null ? (class$java$lang$String = DicomStorageDataModel.class$("java.lang.String")) : class$java$lang$String)) {
            return object.toString();
        }
        return object;
    }

    private List getListAllRequired(String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Object v2 = this.mMap.get(stringArray[i2]);
            if (v2 == null) {
                return null;
            }
            arrayList.add(v2);
        }
        return arrayList;
    }

    public static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

