/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.viewer.dicomstorage.database;

import DataModels.MapDataModel;
import DataModels.ModelProperty;
import InteleViewer.FR;
import InteleViewer.Gg;
import com.intelerad.datamodels.dicom.DicomAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class OutgoingSeries
extends MapDataModel {
    public static final FR PENDING = new FR("PENDING");
    public static final FR SENDING = new FR("SENDING");
    public static final FR SENT = new FR("SENT");
    public static final FR FAILED = new FR("FAILED");
    public static final FR CANCELED = new FR("CANCELED");
    public static final FR IMPORTING = new FR("IMPORTING");
    public static final ModelProperty OutgoingSeriesID = new ModelProperty(class$java$lang$Integer == null ? (class$java$lang$Integer = OutgoingSeries.class$("java.lang.Integer")) : class$java$lang$Integer, "OutgoingSeriesID", "Outgoing Series ID");
    public static final ModelProperty DestinationDescription = new ModelProperty(class$java$lang$String == null ? (class$java$lang$String = OutgoingSeries.class$("java.lang.String")) : class$java$lang$String, "DestinationDescription", "Destination Description");
    public static final ModelProperty DestinationAeTitle = new ModelProperty(class$java$lang$String == null ? (class$java$lang$String = OutgoingSeries.class$("java.lang.String")) : class$java$lang$String, "DestinationAeTitle", "Destination AE Title");
    public static final ModelProperty DestinationHost = new ModelProperty(class$java$lang$String == null ? (class$java$lang$String = OutgoingSeries.class$("java.lang.String")) : class$java$lang$String, "DestinationHost", "Destination Host");
    public static final ModelProperty DestinationPort = new ModelProperty(class$java$lang$Integer == null ? (class$java$lang$Integer = OutgoingSeries.class$("java.lang.Integer")) : class$java$lang$Integer, "DestinationPort", "Destination Port");
    public static final ModelProperty State = new ModelProperty(class$com$intelerad$viewer$dicomstorage$database$OutgoingSeries$StoreState == null ? (class$com$intelerad$viewer$dicomstorage$database$OutgoingSeries$StoreState = OutgoingSeries.class$("InteleViewer.FR")) : class$com$intelerad$viewer$dicomstorage$database$OutgoingSeries$StoreState, "State", "State");
    public static final ModelProperty SendAfter = new ModelProperty(class$java$util$Date == null ? (class$java$util$Date = OutgoingSeries.class$("java.util.Date")) : class$java$util$Date, "SendAfter", "Send After Date");
    public static final ModelProperty FailedAttempts = new ModelProperty(class$java$lang$Integer == null ? (class$java$lang$Integer = OutgoingSeries.class$("java.lang.Integer")) : class$java$lang$Integer, "FailedAttempts", "Failed Store Attempts");
    public static final ModelProperty LastUpdated = new ModelProperty(class$java$util$Date == null ? (class$java$util$Date = OutgoingSeries.class$("java.util.Date")) : class$java$util$Date, "LastUpdated", "Last updated");
    public static final ModelProperty LastError = new ModelProperty(class$java$lang$String == null ? (class$java$lang$String = OutgoingSeries.class$("java.lang.String")) : class$java$lang$String, "LastError", "LastError");
    public static final ModelProperty SentSopInstances = new ModelProperty(class$java$util$List == null ? (class$java$util$List = OutgoingSeries.class$("java.util.List")) : class$java$util$List, "SentSopInstances", "Sent SOP instances");
    public static final ModelProperty UnsentSopInstances = new ModelProperty(class$java$util$List == null ? (class$java$util$List = OutgoingSeries.class$("java.util.List")) : class$java$util$List, "UnsentSopInstances", "Unsent SOP instances");
    public static final ModelProperty CreatedBy = new ModelProperty(class$java$lang$String == null ? (class$java$lang$String = OutgoingSeries.class$("java.lang.String")) : class$java$lang$String, "CreatedBy", "Created By");
    public static final ModelProperty CreatedOn = new ModelProperty(class$java$util$Date == null ? (class$java$util$Date = OutgoingSeries.class$("java.util.Date")) : class$java$util$Date, "CreatedOn", "Created On");
    public static final List PROPERTIES = Collections.unmodifiableList(Arrays.asList(OutgoingSeriesID, DicomAttribute.SeriesInstanceUID, DestinationDescription, DestinationAeTitle, DestinationHost, DestinationPort, State, SendAfter, FailedAttempts, LastUpdated, LastError, SentSopInstances, UnsentSopInstances, CreatedBy, CreatedOn));
    public static Class class$java$lang$Integer;
    public static Class class$java$lang$String;
    public static Class class$com$intelerad$viewer$dicomstorage$database$OutgoingSeries$StoreState;
    public static Class class$java$util$Date;
    public static Class class$java$util$List;

    public OutgoingSeries() {
        Date date = new Date();
        this.setProperty(OutgoingSeriesID, null);
        this.setProperty((ModelProperty)DicomAttribute.SeriesInstanceUID, "");
        this.setProperty(DestinationDescription, "");
        this.setProperty(DestinationAeTitle, "");
        this.setProperty(DestinationHost, "");
        this.setProperty(DestinationPort, new Integer(0));
        this.setProperty(State, (Object)PENDING);
        this.setProperty(SendAfter, date);
        this.setProperty(FailedAttempts, new Integer(0));
        this.setProperty(LastUpdated, date);
        this.setProperty(LastError, "");
        this.setProperty(SentSopInstances, Collections.EMPTY_LIST);
        this.setProperty(UnsentSopInstances, Collections.EMPTY_LIST);
        this.setProperty(CreatedBy, "");
        this.setProperty(CreatedOn, date);
    }

    public Collection getProperties() {
        return PROPERTIES;
    }

    public Object getProperty(ModelProperty modelProperty) throws IllegalArgumentException {
        Object object = super.getProperty(modelProperty);
        if (modelProperty.getValueClass() == (class$java$util$List == null ? (class$java$util$List = OutgoingSeries.class$("java.util.List")) : class$java$util$List) && object != null) {
            return Collections.unmodifiableList((List)object);
        }
        return object;
    }

    public void setProperty(ModelProperty modelProperty, Object object) {
        Object object2;
        ModelProperty modelProperty2;
        OutgoingSeries outgoingSeries;
        if (modelProperty.getValueClass() == (class$java$util$List == null ? (class$java$util$List = OutgoingSeries.class$("java.util.List")) : class$java$util$List)) {
            if (object == null) {
                outgoingSeries = this;
                modelProperty2 = modelProperty;
                object2 = Collections.EMPTY_LIST;
            } else {
                outgoingSeries = this;
                modelProperty2 = modelProperty;
                object2 = new ArrayList((List)object);
            }
        } else {
            outgoingSeries = this;
            modelProperty2 = modelProperty;
            object2 = object;
        }
        super.setProperty(modelProperty2, object2);
    }

    public Integer getId() {
        return (Integer)this.getProperty(OutgoingSeriesID);
    }

    public String getInstanceUid() {
        return (String)this.getProperty(DicomAttribute.SeriesInstanceUID);
    }

    public List getSentSopInstances() {
        return (List)this.getProperty(SentSopInstances);
    }

    public void setSentSopInstances(Collection collection) {
        this.setProperty(SentSopInstances, new ArrayList(collection));
    }

    public List getUnsentSopInstances() {
        return (List)this.getProperty(UnsentSopInstances);
    }

    public void setUnsentSopInstances(Collection collection) {
        this.setProperty(UnsentSopInstances, new ArrayList(collection));
    }

    public FR getState() {
        return (FR)((Object)this.getProperty(State));
    }

    public void setState(FR fR2) {
        this.setProperty(State, (Object)fR2);
    }

    public String getDestinationDescription() {
        return (String)this.getProperty(DestinationDescription);
    }

    public String getDestinationAeTitle() {
        return (String)this.getProperty(DestinationAeTitle);
    }

    public String getDestinationHost() {
        return (String)this.getProperty(DestinationHost);
    }

    public int getDestinationPort() {
        return (Integer)this.getProperty(DestinationPort);
    }

    public void setLastError(String string) {
        this.setProperty(LastError, string);
    }

    public int getFailedAttempts() {
        return (Integer)this.getProperty(FailedAttempts);
    }

    public Date getLastUpdated() {
        return (Date)this.getProperty(LastUpdated);
    }

    public void setLastUpdated(Date date) {
        this.setProperty(LastUpdated, date);
    }

    public Date getCreatedOn() {
        return (Date)this.getProperty(CreatedOn);
    }

    public void setSendAfter(Date date) {
        this.setProperty(SendAfter, date);
    }

    public boolean hasSopInstances() {
        return !this.getUnsentSopInstances().isEmpty() || !this.getSentSopInstances().isEmpty();
    }

    public void sopInstancesSent(Collection collection) {
        ArrayList arrayList = new ArrayList(this.getSentSopInstances());
        arrayList.addAll(collection);
        this.setSentSopInstances(arrayList);
        ArrayList arrayList2 = new ArrayList(this.getUnsentSopInstances());
        arrayList2.removeAll(collection);
        this.setUnsentSopInstances(arrayList2);
    }

    public void incFailedAttempts() {
        int n2 = 1 + (Integer)this.getProperty(FailedAttempts);
        this.setProperty(FailedAttempts, new Integer(n2));
    }

    public String getDestinationUiString() {
        return this.getDestinationAeTitle() + "@" + this.getDestinationHost() + ":" + this.getDestinationPort();
    }

    public String getSeriesUiString() {
        return this.getInstanceUid() + " to " + this.getDestinationUiString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = PROPERTIES.iterator();
        while (iterator.hasNext()) {
            ModelProperty modelProperty = (ModelProperty)iterator.next();
            stringBuffer.append(modelProperty.getName());
            stringBuffer.append("=");
            stringBuffer.append(this.getProperty(modelProperty));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public Gg getAeInfo() {
        return new Gg(this.getDestinationAeTitle(), this.getDestinationHost(), this.getDestinationPort(), this.getDestinationDescription(), false);
    }

    public static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

