/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import StringUtilities.StringPad;
import java.awt.Canvas;
import java.awt.Graphics;
import java.io.PrintStream;
import javax.swing.SwingUtilities;
import vtk.vtkCamera;
import vtk.vtkLight;
import vtk.vtkRenderWindow;
import vtk.vtkRenderer;

public class vtkPanel
extends Canvas {
    private vtkRenderWindow rw = new vtkRenderWindow();
    private vtkRenderer ren = new vtkRenderer();
    private boolean windowset = false;
    private boolean lightingset = false;
    private boolean rendering = false;

    protected native int RenderCreate(vtkRenderWindow var1);

    protected native int Lock();

    protected native int UnLock();

    public vtkPanel() {
        this.rw.AddRenderer(this.ren);
        this.setSize(200, 200);
    }

    public void Report() {
        Runnable runnable = new Runnable(){

            public void run() {
                vtkPanel.this.Lock();
                System.out.println("direct rendering = " + (vtkPanel.this.rw.IsDirect() == 1));
                System.out.println("opengl supported = " + (vtkPanel.this.rw.SupportsOpenGL() == 1));
                System.out.println("report = " + vtkPanel.this.rw.ReportCapabilities());
                vtkPanel.this.UnLock();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void dump(final PrintStream printStream, int n2) {
        final String string = StringPad.getIndentSpaces(n2);
        Runnable runnable = new Runnable(){

            public void run() {
                vtkPanel.this.Lock();
                printStream.println(string + "direct rendering = " + (vtkPanel.this.rw.IsDirect() == 1));
                printStream.println(string + "opengl supported = " + (vtkPanel.this.rw.SupportsOpenGL() == 1));
                printStream.println(string + "report = " + vtkPanel.this.rw.ReportCapabilities());
                printStream.println(vtkPanel.this.rw.Print());
                printStream.println(vtkPanel.this.ren.Print());
                printStream.println(vtkPanel.this.ren.GetActiveCamera().Print());
                vtkPanel.this.UnLock();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public vtkRenderer GetRenderer() {
        return this.ren;
    }

    public void SetRenderer(vtkRenderer vtkRenderer2) {
        this.ren = vtkRenderer2;
    }

    public vtkRenderWindow GetRenderWindow() {
        return this.rw;
    }

    public void SetRenderWindow(vtkRenderWindow vtkRenderWindow2) {
        this.rw = vtkRenderWindow2;
    }

    public void setSize(int n2, int n3) {
        super.setSize(n2, n3);
        if (this.windowset) {
            this.Lock();
            this.rw.SetSize(n2, n3);
            this.UnLock();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.windowset = false;
        this.rw.SetForceMakeCurrent();
        this.rendering = false;
    }

    public void removeNotify() {
        this.rendering = true;
        super.removeNotify();
    }

    public synchronized void Render() {
        if (!this.rendering) {
            this.rendering = true;
            if (this.ren.VisibleActorCount() == 0) {
                this.rendering = false;
                return;
            }
            if (this.rw != null) {
                if (!this.windowset) {
                    vtkCamera vtkCamera2 = this.ren.GetActiveCamera();
                    if (!this.lightingset) {
                        vtkLight vtkLight2 = new vtkLight();
                        this.ren.AddLight(vtkLight2);
                        vtkLight2.SetPosition(vtkCamera2.GetPosition());
                        vtkLight2.SetFocalPoint(vtkCamera2.GetFocalPoint());
                        this.lightingset = true;
                    }
                    this.RenderCreate(this.rw);
                    this.Lock();
                    this.rw.SetSize(this.getWidth(), this.getHeight());
                    this.UnLock();
                    this.windowset = true;
                }
                this.Lock();
                this.rw.Render();
                this.UnLock();
                this.rendering = false;
            }
        }
    }

    public void paint(Graphics graphics) {
        this.Render();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    static {
        System.loadLibrary("vtkCommonJava");
        System.loadLibrary("vtkFilteringJava");
        System.loadLibrary("vtkIOJava");
        System.loadLibrary("vtkImagingJava");
        System.loadLibrary("vtkGraphicsJava");
        System.loadLibrary("vtkRenderingJava");
        try {
            System.loadLibrary("vtkHybridJava");
        }
        catch (Throwable throwable) {
            System.out.println("cannot load vtkHybrid, skipping...");
        }
    }
}

