/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.burlap.server;

import com.caucho.burlap.io.BurlapInput;
import com.caucho.burlap.io.BurlapOutput;
import com.caucho.services.server.AbstractSkeleton;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BurlapSkeleton
extends AbstractSkeleton {
    private Object _service;

    public void invoke(BurlapInput burlapInput, BurlapOutput burlapOutput) throws Throwable {
        burlapInput.startCall();
        Method method = this.getMethod(burlapInput.getMethod());
        if (method == null) {
            if ("_burlap_getAttribute".equals(burlapInput.getMethod())) {
                String string = burlapInput.readString();
                burlapInput.completeCall();
                String string2 = null;
                if ("java.api.class".equals(string)) {
                    string2 = this.getAPIClassName();
                } else if ("java.home.class".equals(string)) {
                    string2 = this.getHomeClassName();
                } else if ("java.object.class".equals(string)) {
                    string2 = this.getObjectClassName();
                }
                burlapOutput.startReply();
                burlapOutput.writeObject(string2);
                burlapOutput.completeReply();
                return;
            }
            if (method == null) {
                burlapOutput.startReply();
                burlapOutput.writeFault("NoSuchMethodException", "The service has no method named: " + burlapInput.getMethod(), null);
                burlapOutput.completeReply();
                return;
            }
        }
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            objectArray[n] = burlapInput.readObject(classArray[n]);
            ++n;
        }
        burlapInput.completeCall();
        Object object = null;
        try {
            object = method.invoke(this._service, objectArray);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (throwable instanceof InvocationTargetException) {
                throwable2 = ((InvocationTargetException)throwable).getTargetException();
            }
            burlapOutput.startReply();
            burlapOutput.writeFault("ServiceException", throwable2.getMessage(), throwable2);
            burlapOutput.completeReply();
            return;
        }
        burlapOutput.startReply();
        burlapOutput.writeObject(object);
        burlapOutput.completeReply();
    }

    public BurlapSkeleton(Object object, Class clazz) {
        super(clazz);
        this._service = object;
    }
}

